% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{as.png.plotmath}
\alias{as.png.plotmath}
\title{Convert Plotmath to PNG}
\usage{
\method{as.png}{plotmath}(
  x,
  filename = tempfile(),
  width = 3,
  height = 1,
  units = "in",
  res = 150,
  ...
)
}
\arguments{
\item{x}{plotmath; see \code{\link{as_plotmath}}}

\item{filename}{path for image file}

\item{width}{width}

\item{height}{height}

\item{units}{units}

\item{res}{resolution}

\item{...}{passed arguments}
}
\value{
invisible filepath
}
\description{
Converts plotmath to png.
}
\examples{
library(magrittr)
library(latexpdf)
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_plotmath \%>\% as.png -> file
file
}
\seealso{
Other preview: 
\code{\link{as.png.spork}()},
\code{\link{as_preview}()},
\code{\link{as_preview.html}()},
\code{\link{as_preview.latex}()},
\code{\link{as_preview.plotmath}()},
\code{\link{as_previews}()},
\code{\link{as_previews.default}()},
\code{\link{as_previews.spork}()},
\code{\link{ggplot.plotmath}()},
\code{\link{ggplot.spork}()}

Other png: 
\code{\link{as.png.spork}()}

Other plotmath: 
\code{\link{[.plotmath}()},
\code{\link{[[.plotmath}()},
\code{\link{as.expression.plotmath}()},
\code{\link{as_plotmath}()},
\code{\link{as_plotmath.greek}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath.spork}()},
\code{\link{concatenate.plotmath}()},
\code{\link{ggplot.plotmath}()},
\code{\link{goodToken}()},
\code{\link{plotmathToken}()}
}
\concept{plotmath}
\concept{png}
\concept{preview}
\keyword{internal}
