% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfkrigeidwpred.R
\name{rfkrigeidwpred}
\alias{rfkrigeidwpred}
\title{Generate spatial predictions using the hybrid methods of 'random forest' ('RF'),
'kriging' and inverse distance weighted ('IDW').}
\usage{
rfkrigeidwpred(
  longlat,
  trainx,
  predx,
  trainy,
  longlatpredx,
  mtry = function(p) max(1, floor(sqrt(p))),
  ntree = 500,
  transformation = "none",
  delta = 1,
  formula.krige = res1 ~ 1,
  vgm.args = c("Sph"),
  anis = c(0, 1),
  alpha = 0,
  block = 0,
  beta,
  nmaxkrige = 12,
  idp = 2,
  nmaxidw = 12,
  hybrid.parameter = 2,
  lambda = 1,
  ...
)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of point samples.}

\item{trainx}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples. That is,
the location information must be named as 'long' and 'lat'.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{trainy}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centers of grids) to be predicted.}

\item{mtry}{a function of number of remaining predictor variables to use as
the 'mtry' parameter in the 'randomForest' call.}

\item{ntree}{number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few times.
By default, 500 is used.
#' @param longlatpredx    a dataframe contains longitude and latitude of point locations
(i.e., the centers of grids) to be predicted. The location information must be
named as 'long' and 'lat'.}

\item{transformation}{transform the residuals of 'rf' to normalise the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation. The default is 1.}

\item{formula.krige}{formula defining the response vector and (possible) regressor.
an object (i.e., 'variogram.formula') for 'variogram' or a formula for
'krige'. see 'variogram' and 'krige' in 'gstat' for details.}

\item{vgm.args}{arguments for 'vgm', e.g. variogram model of response
variable and anisotropy parameters. see 'vgm' in 'gstat' for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes 'vgm' in 'gstat' for details.}

\item{alpha}{direction in plane (x,y). see variogram in 'gstat' for details.}

\item{block}{block size. see 'krige' in 'gstat' for details.}

\item{beta}{for simple kriging. see 'krige' in 'gstat' for details.}

\item{nmaxkrige}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{idp}{a numeric number specifying the inverse distance weighting power.}

\item{nmaxidw}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{hybrid.parameter}{the default is 2 that is for 'rfkrigerfidw';
for 'rfrfkrigerfidw', it needs to be 3.}

\item{lambda, }{ranging from 0 to 2; the default is 1 for 'rfkrigerfidw'
and 'rfrfkrigerfidw'; and if it is < 1, more weight is placed on 'krige',
otherwise more weight is placed on 'idw'; and if it is 0, 'idw' is not
considered and the resultant methods is 'rfkrige' when the default
'hybrid.parameter' is used; and if it is 2, then the resultant method is
'rfidw' when the default 'hybrid.parameter' is used.}

\item{...}{other arguments passed on to 'rf', 'krige' and 'gstat'.}
}
\value{
A dataframe of longitude, latitude, and predictions.
}
\description{
This function is for generating spatial predictions using the
hybrid methods of 'RF', 'kriging' and 'IDW', including all methods implemented
in 'rfkrigeidwcv'.
}
\examples{
\donttest{
library(spm)

data(sponge)
data(sponge.grid)
longlat <- sponge[, 1:2]
y = sponge[, 3]
trainx = sponge[, -3]

set.seed(1234)

rfkrigeidwpred1 <- rfkrigeidwpred(longlat = longlat, trainx =  trainx,
predx = sponge.grid, trainy = y, longlatpredx = sponge.grid[, c(1:2)],
formula.krige = res1 ~ 1, vgm.args = "Sph", nmaxkrige = 12, idp = 2, nmaxidw = 12)

names(rfkrigeidwpred1)

range(rfkrigeidwpred1$predictions)
}

}
\references{
Li, J., Potter, A., Huang, Z., and Heap, A. (2012). Predicting Seabed
Sand Content across the Australian Margin Using Machine Learning and Geostatistical
 Methods, Geoscience Australia, Record 2012/48, 115pp.

Li, J., Heap, A., Potter, A., and Danilel, J.J. (2011). Predicting Seabed Mud Content
across the Australian Margin II: Performance of Machine Learning Methods and Their
Combination with Ordinary Kriging and Inverse Distance Squared, Geoscience Australia,
Record 2011/07, 69pp.

Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.

Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat package.
Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
