% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{split_df}
\alias{split_df}
\title{Split a data frame into two parts}
\usage{
split_df(data, stratification = NULL, ...)
}
\arguments{
\item{data}{(data frame) Data to split, in long format, with one row per
observation.}

\item{stratification}{(vector). Vector that identifies which subsets of
\code{data} should be split separately (denoted as strata in splitting
functions) in order to ensure they are evenly distributed between parts. 
If NULL, all \code{data} is considered a single stratum.}

\item{...}{
  Arguments passed on to \code{\link[=get_split_indexes_from_stratum]{get_split_indexes_from_stratum}}
  \describe{
    \item{\code{method}}{(character) Splitting method. Note that \code{first_second} and
\code{odd_even} splitting method will only deliver a valid split with
default settings for other arguments (\code{subsample_p = 1, split_p = 1,
replace = TRUE})}
    \item{\code{replace}}{(logical) If FALSE, splits are constructed by sampling from
stratum without replacement. If TRUE, stratum is sampled with replacement.}
    \item{\code{split_p}}{(numeric) Desired joint size of both parts, expressed as a
proportion of the size of the subsampled \code{stratum}. If \code{split_p}
is larger than 1, and \code{careful} is FALSE, then parts are automatically
sampled with replacement}
    \item{\code{subsample_p}}{(numeric) Subsample a proportion of \code{stratum} to be
used in the split.}
    \item{\code{careful}}{(boolean) If TRUE, stop with an error when called with
arguments that may yield unexpected splits}
  }}
}
\value{
(list) List with two elements that each contain one of two parts.
}
\description{
Splits \code{data}, Applies a stratified split to a data frame and returns
each part. For more information about splitting options, and an extensive
list of examples, see \code{\link{get_split_indexes_from_stratum}}.
}
\examples{
ds <- data.frame(condition = rep(c("a", "b"), each = 4), score = 1 : 8)
split_df(ds, method = "random")
split_df(ds, method = "odd_even")
split_df(ds, method = "first_second")
split_df(ds, stratification = ds$condition, method = "random")
split_df(ds, stratification = ds$condition, method = "odd_even")
split_df(ds, stratification = ds$condition, method = "first_second")
ds <- data.frame(condition = rep(c("a", "b"), 4), score = 1 : 8)
split_df(ds, method = "random")
split_df(ds, method = "odd_even")
split_df(ds, method = "first_second")
split_df(ds, stratification = ds$condition, method = "random")
split_df(ds, stratification = ds$condition, method = "odd_even")
split_df(ds, stratification = ds$condition, method = "first_second")
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
