% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{check_strata}
\alias{check_strata}
\title{Check whether two strata have the same structure}
\usage{
check_strata(strata_left, strata_right)
}
\arguments{
\item{strata_left}{(list) strata to check against}

\item{strata_right}{(list) strata to check}
}
\value{
None
}
\description{
Checks \code{strata} against \code{strata_left}. Each element of
\code{strata_left} should also be present in \code{strata}, be of a similar
type (data frame/tibble or list/vector), and be of similar size
(\code{\link{nrow}} for data frames/tibbles or \code{\link{length}} for
lists/vectors). Stops with an arror if any checks fail.
}
\examples{
check_strata(list(1 : 4), list(1 : 4))
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
