% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{assmd}
\alias{assmd}
\title{Calculate Absolute Strictly Standardized Mean Difference (ASSMD)}
\usage{
assmd(x, y)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}
}
\value{
(numeric) Absolute SSMD
}
\description{
Returns the absolute difference of the mean of \code{x} and \code{y} 
divided by their shared standard deviation. Since the resulting difference 
is absolute, the larger of the two means is always used as minuend and the
smallest as subtrahend. Based on 
Zhang (2012) <\doi{10.1016/j.ygeno.2006.12.014}>
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate Absolute SSMD
assmd(vars[,1], vars[,2])
}
\seealso{
Other splithalfr coefficients: 
\code{\link{angoff_feldt}()},
\code{\link{flanagan_rulon}()},
\code{\link{sdregi}()},
\code{\link{short_icc}()},
\code{\link{spearman_brown}()}
}
\concept{splithalfr coefficients}
