% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{ncs_plot_means_subgroup}
\alias{ncs_plot_means_subgroup}
\title{Plot Actual and Predicted Response Variable Means by Study Arm and Subgroup.}
\usage{
ncs_plot_means_subgroup(
  data,
  arm = "arm",
  time = "time",
  subgroup = "subgroup",
  est = "est",
  lower = "lower",
  upper = "upper",
  model_est = "response_est",
  model_lower = "response_lower",
  model_upper = "response_upper"
)
}
\arguments{
\item{data}{(\verb{data frame})\cr a data frame, probably produced by
\code{\link[=ncs_analysis]{ncs_analysis()}}, containing the actual and predicted means. Each row
should have a unique combination of \code{arm}, \code{time}, and \code{subgroup}.}

\item{arm}{(\code{string})\cr the name of the study arm variable in \code{data}. There
will be a \link[ggplot2:facet_grid]{separate column of plots produced} for each
study arm.}

\item{time}{(\code{string})\cr the name of the time or visit variable in \code{data}.
These values correspond to the x-axis.}

\item{subgroup}{(\code{string})\cr the name of the subgroup variable in \code{data}.
There will be a \link[ggplot2:facet_grid]{separate row of plots produced} for
each subgroup.}

\item{est, lower, upper}{(\code{string})\cr the name of the variables in \code{data}
containing the actual response variable's mean and confidence interval
bounds. These values correspond to the y-axis.}

\item{model_est, model_lower, model_upper}{(\code{string})\cr the name of the
variables in \code{data} containing the predicted response variable's mean and
confidence interval bounds. These values correspond to the y-axis.}
}
\value{
An object returned by \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
This function accepts a data set, probably produced by
\code{\link[=ncs_analysis_subgroup]{ncs_analysis_subgroup()}}, and it uses \link[ggplot2:ggplot2-package]{ggplot2} to
produce a \link[ggplot2:facet_grid]{grid} of plots, one for each combination of
study \code{arm} and \code{subgroup}. The \code{time} variable is along the x-axis, and the
response variable is along the y-axis. The actual means of the response
variable are \link[ggplot2:geom_point]{points} plotted in one color, and the
modeled means are plotted in another color. Each point also has its
confidence interval \link[ggplot2:geom_linerange]{plotted}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

# Analysis result data set
ncs_data_results_subgroup <-
  ncs_analysis_subgroup(
    data = fev_mod,
    response = FEV1,
    subject = USUBJID,
    arm = ARMCD,
    control_group = "PBO",
    subgroup = RACE,
    subgroup_comparator = "Asian",
    time_observed_continuous = time_cont,
    df = 2,
    time_observed_index = obs_visit_index,
    time_scheduled_continuous = VISITN,
    time_scheduled_baseline = 10,
    time_scheduled_label = AVISIT,
    covariates = ~ FEV1_BL + RACE,
    cov_structs = c("ar1", "us")
  )

ncs_plot_means_subgroup(ncs_data_results_subgroup$between)
\dontshow{\}) # examplesIf}
}
