% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{ncs_plot_means}
\alias{ncs_plot_means}
\title{Plot Actual and Predicted Response Variable Means by Study Arm.}
\usage{
ncs_plot_means(
  data,
  arm = "arm",
  time = "time",
  est = "est",
  lower = "lower",
  upper = "upper",
  model_est = "response_est",
  model_lower = "response_lower",
  model_upper = "response_upper"
)
}
\arguments{
\item{data}{(\verb{data frame})\cr a data frame, probably produced by
\code{\link[=ncs_analysis]{ncs_analysis()}}, containing the actual and predicted means. Each row
should have a unique combination of \code{arm} and \code{time}.}

\item{arm}{(\code{string})\cr the name of the study arm variable in \code{data}. There
will be a \link[ggplot2:facet_wrap]{separate plot produced} for each study arm.}

\item{time}{(\code{string})\cr the name of the time or visit variable in \code{data}.
These values correspond to the x-axis.}

\item{est, lower, upper}{(\code{string})\cr the name of the variables in \code{data}
containing the actual response variable's mean and confidence interval
bounds. These values correspond to the y-axis.}

\item{model_est, model_lower, model_upper}{(\code{string})\cr the name of the
variables in \code{data} containing the predicted response variable's mean and
confidence interval bounds. These values correspond to the y-axis.}
}
\value{
An object returned by \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
This function accepts a data set, probably produced by \code{\link[=ncs_analysis]{ncs_analysis()}}, and
it uses \link[ggplot2:ggplot2-package]{ggplot2} to produce a \link[ggplot2:facet_wrap]{panel}
of plots, one for each study \code{arm}. The \code{time} variable is along the x-axis,
and the response variable is along the y-axis. The actual means of the
response variable are \link[ggplot2:geom_point]{points} plotted in one color, and
the modeled means are plotted in another color. Each point also has its
confidence interval \link[ggplot2:geom_linerange]{plotted}.
}
\examples{
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

# Analysis result data set
ncs_data_results <-
  ncs_analysis(
    data = fev_mod,
    response = FEV1,
    subject = USUBJID,
    arm = ARMCD,
    control_group = "PBO",
    time_observed_continuous = time_cont,
    df = 2,
    time_observed_index = obs_visit_index,
    time_scheduled_continuous = VISITN,
    time_scheduled_baseline = 10,
    time_scheduled_label = AVISIT,
    covariates = ~ FEV1_BL + RACE,
    cov_structs = c("ar1", "us")
  )

ncs_plot_means(ncs_data_results)
}
