#' Abundance of 14 pseudo-species.
#' A dataset containing the abundance values of 14 pseudo-species in 100
#' samples. The environmental conditions associated with each samples are
#' described in the environment dataset. Pseudo-species v1 and v2, v3 and v4,
#' v5 and v6, v7 and v8, v9 and v10, v11 and v12, v13 and v14 have the same
#' niche.
#'
#' @name data_abundance
#' @docType data
#' @author Loïck Kléparski \email{loick.kleparski@hotmail.fr}
#' @keywords data
#' @usage data(data_abundance)
#'
#' @format A data frame with 100 rows and 14 variables:
#' \describe{
#'   \item{PS1}{Abundance of pseudo-species 1}
#'   \item{PS2}{Abundance of pseudo-species 2}
#'   \item{PS3}{Abundance of pseudo-species 3}
#'   \item{PS4}{Abundance of pseudo-species 4}
#'   \item{PS5}{Abundance of pseudo-species 5}
#'   \item{PS6}{Abundance of pseudo-species 6}
#'   \item{PS7}{Abundance of pseudo-species 7}
#'   \item{PS8}{Abundance of pseudo-species 8}
#'   \item{PS9}{Abundance of pseudo-species 9}
#'   \item{PS10}{Abundance of pseudo-species 10}
#'   \item{PS11}{Abundance of pseudo-species 11}
#'   \item{PS12}{Abundance of pseudo-species 12}
#'   \item{PS13}{Abundance of pseudo-species 13}
#'   \item{PS14}{Abundance of pseudo-species 14}
#'   ...
#' }
"data_abundance"
