% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{make_scrambled_halton}
\alias{make_scrambled_halton}
\title{Make scrambled Halton draws}
\usage{
make_scrambled_halton(n_ind, n_draws, n_dim)
}
\arguments{
\item{n_ind}{Number of individuals in your sample}

\item{n_draws}{Number of draws per respondent}

\item{n_dim}{Number of dimensions}
}
\description{
A function for creating scrambled Halton draws. The code is a translation of
the [GAUSS](http://www.caee.utexas.edu/prof/bhat/FULL_CODES.htm) codes
written by Professor Chandra Bhat. Note that the maximum number of dimensions
for the scrambled Halton draws is limited to 16. This is because only
permutations up to prime 16 are included in the permutation matrix. Extending
to more than 16 dimensions can be achieved by including a different
permutation matrix.
}
\details{
The permutations are based on the Braaten-Weller algorithm.
}
\references{
Bhat, C. n_draws., 2003, Simulation Estimation of Mixed Descrete
Choice Models Using Randomized and Scrambled Halton Sequences, Transportation
Research Part B, 9, pp. 837-855
}
