% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaltonFrames.R
\name{getHaltonFrame}
\alias{getHaltonFrame}
\title{Obtain a Halton Frame over a shapefile.}
\usage{
getHaltonFrame(shapefile, J, i, bases, seeds, crs)
}
\arguments{
\item{shapefile}{A MULTIPOINT or POINT object that we want to generate a halton frame for.}

\item{J}{The number of grid cells. A list of 2 values.}

\item{i}{An integer to add to the J parameter elements to expand the Halton Frame in both
directions if the required number of sample points cannot be found in the region of interest
in the current Halton frame.}

\item{bases}{Co-prime base for the Halton Sequence.}

\item{seeds}{A list of 2 seeds, u1 and u2.}

\item{crs}{Coordinate reference system for the shapefile.}
}
\value{
A list containing the following variables: hf_, sample, pts.shp, bb.new, seeds
}
\description{
An internal only function.
}
\details{
This function was written by Phil Davies.
}
\keyword{internal}
