% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidatePanelDesign.R
\name{PanelDesignAssignPanelids}
\alias{PanelDesignAssignPanelids}
\title{Assign panel ids to the samples.}
\usage{
PanelDesignAssignPanelids(
  smp,
  panels,
  panel_overlap,
  panel_design,
  number_panels,
  verbose = FALSE
)
}
\arguments{
\item{smp}{The shapefile for the region under study.}

\item{panels}{A list of integers that defines the size of each panel in a
non-overlapping panels design. The length of the list determines the number of
panels required. The sum of the integers in the panels parameter will determine
the total number of samples selected, n. The default value for panels is NULL,
this indicates that a non-overlapping panel design is not wanted.}

\item{panel_overlap}{A list of integers that define the overlap into the previous
panel. Is only used when the panels parameter is not NULL. The default value for
panel_overlap is NULL. The length of panel_overlap must be equal to the length
of panels. The first value is always forced to zero as the first panel never
overlaps any region.}

\item{panel_design}{A flag, when TRUE, indicates that we are performing a panel design and
the parameters used are specified in the panels and panel_overlap parameters.}

\item{number_panels}{The number of sample panels required.}

\item{verbose}{Boolean, set TRUE if you want to see output messaged to screen. Default is FALSE
i.e. no informational messages are displayed.}
}
\value{
Returns a list of the following variables:

\itemize{
\item \code{sample} This is a sample from the original shapefile that has had the
appropriate panel id's add as a feature. The panel id values are determined by the
panels and panel_overlap parameters.
}
}
\description{
This function assigns panel id's to each sample based on values in the
panels and panel_overlap parameters. This is an internal only function.
}
\author{
Phil Davies.
}
\keyword{internal}
