% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\alias{simulate-spatPomp}
\alias{simulate,spatPomp-method}
\title{Simulation of a spatiotemporal partially-observed Markov process}
\usage{
\S4method{simulate}{spatPomp}(
  object,
  nsim = 1,
  seed = NULL,
  format = c("spatPomps", "data.frame"),
  include.data = FALSE,
  ...
)
}
\arguments{
\item{object}{optional;
if present, it should be a data frame or a \sQuote{pomp} object.}

\item{nsim}{number of simulations.}

\item{seed}{optional integer;
if set, the pseudorandom number generator (RNG) will be initialized with \code{seed}.
The RNG will be restored to its original state afterward.}

\item{format}{the format of the simulated results. If the argument is
set to \code{'spatPomps'}, the default behavior, then the output is a
\code{list} of \code{spatPomp} objects. Options are \code{'spatPomps'}
and \code{'data.frame'}.}

\item{include.data}{if \code{TRUE}, the original data and covariates (if any) are included (with \code{.id = "data"}).
This option is ignored unless \code{format = "data.frame"}.}

\item{...}{additional arguments are passed to \code{\link[pomp]{pomp}}.}
}
\value{
if \code{format='spatPomps'} and \code{nsim=1} an object of class \sQuote{spatPomp} representing a simulation from the model in \code{object} is returned.
If \code{format='spatPomps'} and \code{nsim>1} a list of class \sQuote{spatPomp} objects is returned.
If \code{format='data.frame'} then a class \sQuote{data.frame} object is returned.
}
\description{
\code{simulate} generates simulations of the latent and measurement
processes.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
# Get a spatPomp object
b <- bm(U=2, N=5)
# Get 2 simulations from same model as data.frame
sims <- simulate(b, nsim=2, format='data.frame')
}
}
\references{
\asfaw2020
}
\author{
Kidus Asfaw
}
