% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_sparse_elements.R
\name{has_sparse_elements}
\alias{has_sparse_elements}
\title{Check for sparse elements}
\usage{
has_sparse_elements(x)
}
\arguments{
\item{x}{a data frame, tibble, or list.}
}
\value{
A single logical value.
}
\description{
This function checks to see if a data.frame, tibble or list contains one or
more sparse vectors.
}
\details{
The checking in this function is done using \code{\link[=is_sparse_vector]{is_sparse_vector()}}, but is
implemented using an early exit pattern to provide fast performance for wide
data.frames.

This function does not test whether \code{x} is a data.frame, tibble or list. It
simply iterates over the elements and sees if they are sparse vectors.
}
\examples{
\dontshow{if (rlang::is_installed("Matrix")) withAutoprint(\{ # examplesIf}
set.seed(1234)
n_cols <- 10000
mat <- matrix(sample(0:1, n_cols * 10, TRUE, c(0.9, 0.1)), ncol = n_cols)
colnames(mat) <- as.character(seq_len(n_cols))
sparse_mat <- Matrix::Matrix(mat, sparse = TRUE)

res <- coerce_to_sparse_tibble(sparse_mat)
has_sparse_elements(res)

has_sparse_elements(mtcars)
\dontshow{\}) # examplesIf}
}
