% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmatic.R
\name{sparse-arithmatic-scalar}
\alias{sparse-arithmatic-scalar}
\alias{sparse_division_scalar}
\alias{sparse_multiplication_scalar}
\alias{sparse_addition_scalar}
\alias{sparse_subtraction_scalar}
\title{Scalar arithmatic with sparse vectors}
\usage{
sparse_division_scalar(x, val)

sparse_multiplication_scalar(x, val)

sparse_addition_scalar(x, val)

sparse_subtraction_scalar(x, val)
}
\arguments{
\item{x}{A sparse vector.}

\item{val}{A single numeric value.}
}
\value{
A sparse vector of same type.
}
\description{
Do Arithmatic on sparse vectors without destroying the sparsity. Note that
only multiplication and division preserves the default value.
}
\details{
No checking of the inputs are being done.

\code{sparse_division_scalar()} and \code{sparse_multiplication_scalar()} are the most
used ones, as they preserve the default, which is often what you want to do.

\code{sparse_division_scalar()} always produces double vectors, regardless of
whether they could be represented as integers or not. Expect when \code{val = 1}
as the input is returned unchanged, or \code{val = NA} as the input returned will
be \code{NA} or the appropiate type.
}
\examples{
x_sparse <- sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10)

sparse_division_scalar(x_sparse, 2)
sparse_multiplication_scalar(x_sparse, 2)
sparse_addition_scalar(x_sparse, 2)
sparse_subtraction_scalar(x_sparse, 2)
}
