% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_types.R
\name{struct_type}
\alias{struct_type}
\alias{struct_field}
\alias{array_type}
\alias{binary_type}
\alias{boolean_type}
\alias{byte_type}
\alias{date_type}
\alias{double_type}
\alias{float_type}
\alias{integer_type}
\alias{numeric_type}
\alias{long_type}
\alias{map_type}
\alias{string_type}
\alias{character_type}
\alias{timestamp_type}
\title{Spark Data Types}
\usage{
struct_type(sc, struct_fields)

struct_field(sc, name, data_type, nullable = FALSE)

array_type(sc, data_type, nullable = FALSE)

binary_type(sc)

boolean_type(sc)

byte_type(sc)

date_type(sc)

double_type(sc)

float_type(sc)

integer_type(sc)

numeric_type(sc)

long_type(sc)

map_type(sc, key_type, value_type, nullable = FALSE)

string_type(sc)

character_type(sc)

timestamp_type(sc)
}
\arguments{
\item{sc}{A \code{spark_connection}}

\item{struct_fields}{A vector or fields obtained from \code{struct_field()}}

\item{name}{A field name to use in the output struct type}

\item{data_type}{A (java) data type (e.g., \code{string_type()} or \code{double_type()})}

\item{nullable}{Logical. Describes whether field can be missing for some rows.}

\item{key_type}{A (java) data type describing the map keys (usually \code{string_type()})}

\item{value_type}{A (java) data type describing the map values}
}
\description{
These function support supplying a spark read schema. This is particularly useful
when reading data with nested arrays when you are not interested in several of 
the nested fields.
}
