% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_svs_edited.R
\name{fit_svs_edited}
\alias{fit_svs_edited}
\title{Edited SVS 1H brain analysis pipeline.}
\usage{
fit_svs_edited(
  input,
  w_ref = NULL,
  output_dir = NULL,
  mri = NULL,
  mri_seg = NULL,
  deface = FALSE,
  segment_t1 = FALSE,
  external_basis = NULL,
  p_vols = NULL,
  format = NULL,
  editing_type = "gaba_1.9",
  editing_scheme = NULL,
  invert_edit_on = NULL,
  invert_edit_off = NULL,
  pul_seq = NULL,
  TE = NULL,
  TR = NULL,
  TE1 = NULL,
  TE2 = NULL,
  TE3 = NULL,
  TM = NULL,
  append_basis_ed_off = NULL,
  remove_basis_ed_off = NULL,
  pre_align = TRUE,
  dfp_corr = TRUE,
  output_ratio = NULL,
  ecc = FALSE,
  hsvd_width = NULL,
  decimate = FALSE,
  trunc_fid_pts = NULL,
  fit_opts_edited = NULL,
  fit_opts_ed_off = NULL,
  fit_subset = NULL,
  legacy_ws = FALSE,
  w_att = 0.7,
  w_conc = 35880,
  use_basis_cache = "auto",
  summary_measures = NULL,
  dyn_av_block_size = NULL,
  dyn_av_scheme = NULL,
  dyn_av_scheme_file = NULL,
  plot_ppm_xlim = NULL,
  extra_output = FALSE,
  verbose = FALSE,
  return_fit = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{input}{path or mrs_data object containing MRS data.}

\item{w_ref}{path or mrs_data object containing MRS water reference data.}

\item{output_dir}{directory path to output fitting results.}

\item{mri}{filepath or nifti object containing anatomical MRI data.}

\item{mri_seg}{filepath or nifti object containing segmented MRI data.}

\item{deface}{option to apply fsl_deface to the mri input. Defaults to FALSE.}

\item{segment_t1}{segment the t1 weighted mri file with FSL FAST and use the
results to perform partial volume correction. Defaults to FALSE.}

\item{external_basis}{precompiled basis set object to use for analysis.}

\item{p_vols}{a numeric vector of partial volumes expressed as percentages.
Defaults to 100\% white matter. A voxel containing 100\% gray matter tissue
would use : p_vols = c(WM = 0, GM = 100, CSF = 0).}

\item{format}{Override automatic data format detection. See format argument
in \code{\link[=read_mrs]{read_mrs()}} for permitted values.}

\item{editing_type}{can be one of : "gaba_1.9" or "gsh_4.54". Defaults to
"gaba_1.9".}

\item{editing_scheme}{describes the dynamic data ordering. Can be one of:
'on-off-blocks', 'on-off-interleaved', 'off-on-blocks' or
'off-on-interleaved'.}

\item{invert_edit_on}{set to TRUE to invert the edit-on sub-spectra.}

\item{invert_edit_off}{set to TRUE to invert the edit-off sub-spectra.}

\item{pul_seq}{Pulse sequence to use for basis simulation. Can be one of the
following values : "press", "press_ideal", "press_shaped", "steam" or
"slaser". If "press" then "press_ideal" will be assumed unless the magnetic
field is stronger that 2.8 Tesla, "press_shaped" will be assumed for 2.9
Tesla and above.}

\item{TE}{metabolite mrs data echo time in seconds. If not supplied this will
be guessed from the metab data file.}

\item{TR}{metabolite mrs data repetition time in seconds. If not supplied
this will be guessed from the metab data file.}

\item{TE1}{PRESS or sLASER sequence timing parameter in seconds.}

\item{TE2}{PRESS or sLASER sequence timing parameter in seconds.}

\item{TE3}{sLASER sequence timing parameter in seconds.}

\item{TM}{STEAM mixing time parameter in seconds.}

\item{append_basis_ed_off}{names of extra signals to add to the default
basis. Eg append_basis_ed_off = c("peth", "cit"). Cannot be used with
precompiled basis sets.}

\item{remove_basis_ed_off}{grep expression to match names of signals to
remove from the basis. For example: use "*" to remove all signals, "^mm|^lip"
to remove all macromolecular and lipid signals, "^lac" to remove lactate.
This operation is performed before signals are added with
append_basis_ed_off. Cannot be used with precompiled basis sets.}

\item{pre_align}{perform simple frequency alignment to known reference peaks.}

\item{dfp_corr}{perform dynamic frequency and phase correction using the RATS
method.}

\item{output_ratio}{optional string to specify a metabolite ratio to output.
Defaults to "tCr". Multiple metabolites may be specified for multiple
outputs. Set to NA to omit.}

\item{ecc}{option to perform water reference based eddy current correction,
defaults to FALSE.}

\item{hsvd_width}{set the width of the HSVD filter in Hz. Note the applied
width is between -width and +width Hz, with 0 Hz being defined at the centre
of the spectral width. Default is disabled (set to NULL), 30 Hz is a
reasonable value.}

\item{decimate}{option on decimate the data by a factor of 2 before analysis.
Defaults to FALSE.}

\item{trunc_fid_pts}{number of points to truncate the input data by in the
time-domain. E.g. setting to 1024 will ensure data with more time-domain
points will be truncated to a length of 1024. Defaults to NULL, where
truncation is not performed.}

\item{fit_opts_edited}{options to pass to the fitting method for the
edited spectrum.}

\item{fit_opts_ed_off}{options to pass to the fitting method for the
edit-off spectrum.}

\item{fit_subset}{specify a subset of dynamics to analyse, for example
1:16 would only fit the first 16 dynamic scans.}

\item{legacy_ws}{perform and output legacy water scaling compatible with
default LCModel and TARQUIN behaviour. See w_att and w_conc arguments to
change the default assumptions. Default value is FALSE.}

\item{w_att}{water attenuation factor (default = 0.7) for legacy water
scaling. Assumes water T2 of 80ms and a TE = 30 ms. exp(-30ms / 80ms) ~ 0.7.}

\item{w_conc}{assumed water concentration (default = 35880) for legacy water
scaling. Default value corresponds to typical white matter. Set to 43300 for
gray matter, and 55556 for phantom measurements.}

\item{use_basis_cache}{Pre-cache basis sets to reduce analysis speed. Can be
one of the following : "auto", "all" or "none". The default value of "auto"
will only use the cache for 3T PRESS - which generally requires more detailed
simulation due to high CSD.}

\item{summary_measures}{output an additional table with a subset of
metabolite levels, eg c("tNAA", "tNAA/tCr", "tNAA/tCho", "Lac/tNAA").}

\item{dyn_av_block_size}{perform temporal averaging with the specified block
size. Defaults to NULL, eg average across all dynamic scans.}

\item{dyn_av_scheme}{a numeric vector of sequential integers (starting at 1),
with the same length as the number of dynamic scans in the metabolite data.
For example: c(1, 1, 2, 1, 1, 3, 1, 1).}

\item{dyn_av_scheme_file}{a file path containing a single column of
sequential integers (starting at 1) with the same length as the number of
dynamic scans in the metabolite data. File may be formatted as .xlsx, .xls,
text or csv format.}

\item{plot_ppm_xlim}{plotting ppm axis limits in the html results.
results.}

\item{extra_output}{write extra output files for generating custom plots.
Defaults to FALSE.}

\item{verbose}{output potentially useful information.}

\item{return_fit}{return a fit object, defaults to FALSE.}

\item{overwrite}{overwrite existing fitting result files, defaults to
FALSE.}
}
\description{
Note this function is still under development and liable to changes.
}
\examples{
metab <- system.file("extdata", "philips_spar_sdat_WS.SDAT",
                     package = "spant")
w_ref <- system.file("extdata", "philips_spar_sdat_W.SDAT",
                     package = "spant")
out_dir <- file.path("~", "fit_svs_result")
\dontrun{
fit_result <- fit_svs(metab, w_ref, out_dir)
}
}
