% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disconnect.R
\name{spod_disconnect}
\alias{spod_disconnect}
\title{Safely disconnect from data and free memory}
\usage{
spod_disconnect(tbl_con, free_mem = TRUE)
}
\arguments{
\item{tbl_con}{A \code{tbl_duckdb_connection} connection object that you get from either \code{spod_get()} or \code{spod_connect()}.}

\item{free_mem}{A \code{logical}. Whether to free up memory by running \code{gc()}. Defaults to \code{TRUE}.}
}
\value{
No return value, called for side effect of disconnecting from the database and freeing up memory.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function is to ensure that \code{DuckDB} connections to CSV.gz files (created via \code{spod_get()}), as well as to \code{DuckDB} files or folders of \code{parquet} files (created via \code{spod_convert()}) are closed properly to prevent conflicting connections. Essentially this is just a wrapper around \code{DBI::dbDisconnect()} that reaches out into the \code{.$src$con} object of the \code{tbl_duckdb_connection} connection object that is returned to the user via \code{spod_get()} and \code{spod_connect()}. After disonnecting the database, it also frees up memory by running \code{gc()}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
\donttest{
# Set data dir for file downloads
spod_set_data_dir(tempdir())

# basic example
# create a connection to the v1 data without converting
# this creates a duckdb database connection to CSV files
od_distr <- spod_get(
 "od",
 zones = "distr",
 dates = c("2020-03-01", "2020-03-02")
)
# disconnect from the database connection
spod_disconnect(od_distr)

# Advanced example
# download and convert data
dates_1 <- c(start = "2020-02-17", end = "2020-02-19")
db_2 <- spod_convert(
 type = "od",
 zones = "distr",
 dates = dates_1,
 overwrite = TRUE
)

# now connect to the converted data
my_od_data_2 <- spod_connect(db_2)

# disconnect from the database
spod_disconnect(my_od_data_2)
}
\dontshow{\}) # examplesIf}
}
