#' Metadata from State of the Union Addresses
#'
#' A data frame containing one row per State of the Union
#' Address. These line up with the elements in
#' \code{\link{sotu_text}}.
#'
#' @name sotu_meta
#' @docType data
#' @references The American Presidency Project, UCSB
#' @keywords data
NULL

#' State of the Union Address Text
#'
#' A character vector with one State of the Union in each
#' element. These line up with the rows of the data in
#' \code{\link{sotu_meta}}.
#'
#' @name sotu_text
#' @docType data
#' @references The American Presidency Project, UCSB
#' @keywords data
NULL
