% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{AbsorptionSoundSeaWaterFrancoisGarrison}
\alias{AbsorptionSoundSeaWaterFrancoisGarrison}
\title{Calculation of absorption of sound in sea water From Francois & Garrison 1982}
\source{
NPL, 2016
Underwater Acoustics Technical Guides - Speed of Sound in Sea Water
\url{http://resource.npl.co.uk/acoustics/techguides/seaabsorption/}
}
\usage{
AbsorptionSoundSeaWaterFrancoisGarrison(SonarFreq, temperatureC, Salinity, D,
  pH)
}
\arguments{
\item{SonarFreq,}{sonar frequency (kHz)}

\item{temperatureC,}{temperature (degC)}

\item{Salinity,}{Salinity (ppt)}

\item{D,}{depth in meters}

\item{pH,}{pH}
}
\value{
the absorption of sound
}
\description{
Returns the absorption of sound in sea water From Francois & Garrison 1982
Total absorption = Boric Acid Contrib. + Magnesium Sulphate Contrib.
+ Pure Water Contrib.
}
\examples{
AbsorptionSoundSeaWaterFrancoisGarrison(50, 0, 35, 0, 6)
}
\author{
Jose Gama
}
\references{
Francois & Garrison 1982
Sound absorption based on ocean measurements:
Part I:Pure water and magnesium sulfate contributions
J. Acoust. Soc. Am., Vol. 72, No. 6
}

