% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_upsert.R
\name{doc_upsert}
\alias{doc_upsert}
\title{Create a new document or update an existing one}
\usage{
doc_upsert(cushion, dbname, doc, docid)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{doc}{(character) Document content. Required.}

\item{docid}{(character) Document ID. Required.}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Create a new document or update an existing one
}
\details{
Internally, this function attempts to update a document with the given name. \cr
If the document does not exist, it is created
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, 'sofadb')

# create a document
doc1 <- '{"name": "drink", "beer": "IPA", "score": 5}'
doc_upsert(x, dbname="sofadb", doc1, docid="abeer")

#update the document
doc2 <- '{"name": "drink", "beer": "lager", "score": 6}'
doc_upsert(x, dbname="sofadb", doc2, docid="abeer")


doc_get(x, dbname = "sofadb", docid = "abeer")
}
}
\author{
George Kritikos
}
