% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\alias{design_create}
\alias{design_create_}
\alias{design_delete}
\alias{design_get}
\alias{design_head}
\alias{design_info}
\title{Work with design documents}
\usage{
design_create(
  cushion,
  dbname,
  design,
  fxnname,
  key = "null",
  value = "doc",
  as = "list",
  ...
)

design_create_(cushion, dbname, design, fxnname, fxn, as = "list", ...)

design_delete(cushion, dbname, design, as = "list", ...)

design_get(cushion, dbname, design, as = "list", ...)

design_head(cushion, dbname, design, ...)

design_info(cushion, dbname, design, ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. required.}

\item{design}{(character) Design document name. this is the design name
without \verb{_design/}, which is prepended internally. required.}

\item{fxnname}{(character) A function name. required for \code{view_put}
and \code{view_put_}}

\item{key, value}{(character) a key and value, see Examples and Details}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}

\item{fxn}{(character) a javascript function. required for \code{view_put_}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Work with design documents
}
\details{
\code{design_create} is a slightly easier interface to creating
design documents; it just asks for a function name, the key and a
value, then we create the function for you internally. TO have more
flexibility use \code{view_put_} (with underscore on the end) to write the
function yourself.
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

file <- system.file("examples/omdb.json", package = "sofa")
strs <- readLines(file)

## create a database
if ("omdb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="omdb"))
}
db_create(x, dbname='omdb')

## add the documents
invisible(db_bulk_create(x, "omdb", strs))

# Create a view, the easy way, but less flexible
design_create(x, dbname='omdb', design='view1', fxnname="foobar1")
design_create(x, dbname='omdb', design='view2', fxnname="foobar2",
  value="doc.Country")
design_create(x, dbname='omdb', design='view5', fxnname="foobar3",
  value="[doc.Country,doc.imdbRating]")

# the harder way, write your own function, but more flexible
design_create_(x, dbname='omdb', design='view22',
  fxnname = "stuffthings", fxn = "function(doc){emit(null,doc.Country)}")

# Delete a view
design_delete(x, dbname='omdb', design='view1')

# Get info on a design document
## HEAD request, returns just response headers
design_head(x, dbname='omdb', design='view2')
design_head(x, dbname='omdb', design='view5')
## GET request, returns information about the design document
design_info(x, dbname='omdb', design='view2')
design_info(x, dbname='omdb', design='view5')

# Get a design document (GET request)
design_get(x, dbname='omdb', design='view2')
design_get(x, dbname='omdb', design='view5')

# Search using a view
res <- design_search(x, dbname='omdb', design='view2', view='foobar2')
head(
  do.call(
    "rbind.data.frame",
    lapply(res$rows, function(x) Filter(length, x))
  )
)

res <- design_search(x, dbname='omdb', design='view5', view='foobar3')
head(
  structure(do.call(
    "rbind.data.frame",
    lapply(res$rows, function(x) x$value)
  ), .Names = c('Country', 'imdbRating'))
)
}
}
