% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_model.R
\name{sk_nLL}
\alias{sk_nLL}
\title{Negative log-likelihood for parameter vector \code{p}}
\usage{
sk_nLL(p, g_obs, pars_fix, X = 0, iso = FALSE, quiet = TRUE, log_scale = FALSE)
}
\arguments{
\item{p}{numeric vector of covariance parameters accepted by \code{sk_pars_update}}

\item{g_obs}{sk object or list with entries 'gdim', 'gres', 'gval'}

\item{pars_fix}{list of form returned by \code{sk_pars} (with entries 'y', 'x', 'eps', 'psill')}

\item{X}{numeric, vector, matrix, or NA, the mean or its linear predictors, passed to \code{sk_LL}}

\item{iso}{logical, indicates to use identical kernels for x and y (\code{pars$x} is ignored)}

\item{quiet}{logical indicating to suppress console output}

\item{log_scale}{logical, indicates that \code{pars_fix} contains log-parameter values}
}
\value{
numeric, the negative log-likelihood of \code{p} given data \code{g_obs}
}
\description{
Returns the negative log-likelihood of covariance model \code{pars_fix}, given the observations
in data grid \code{g_obs}. Parameter values are copied from the first argument, vector \code{p}, so
that the function can be passed to numerical optimizers (etc).
}
\details{
This is a wrapper for \code{sk_LL} (times -1) that allows parameters to be passed as a numeric
vector instead of a list. Parameters in \code{p} are copied to \code{pars_fix} and passed to the
likelihood computer.

\code{p} is the vector of covariance parameters to test. Names in \code{p} are ignored; Its length
and order should correspond with the pattern of NAs in \code{pars_fix}. Users should check that
the desired parameter list is being constructed correctly by testing with:
\code{sk_pars_update(pars_fix, p, iso=iso, na_omit=TRUE)}.
}
\examples{
# set up example grid and data
g = sk(gdim=10, gval=stats::rnorm(10^2))

# get some default parameters and vectorize them
pars = sk_pars(g, 'gau')
p = sk_pars_update(pars)
sk_nLL(p, g, pars)

# change a parameter in the numeric vector and re-evaluate
p_compare = p
p_compare[1] = 2 * p_compare[1]
sk_nLL(p_compare, g, pars)

# repeat by calling sk_LL directly with modified parameters list
pars_compare = pars
pars_compare[['eps']] = 2 * pars_compare[['eps']]
-sk_LL(pars_compare, g)

# set up a subset of parameters to replace - eg when fitting those parameters
pars_fix = pars
pars_fix[['eps']] = NA
pars_fix[['y']][['kp']] = NA

# names in p_fit are for illustration only (only the order matters)
p_fit = c(eps=1, y.rho=1)

# replace NA parameter values in pars_fix to get completed parameters list
sk_pars_update(pars_fix, p_fit, na_omit=TRUE)

# make the replacement and evaluate likelihood in one call
sk_nLL(p_fit, g, pars_fix)

# equivalently:
pars_fit = pars
pars_fit[['eps']] = p_fit[1]
pars_fit[['y']][['kp']] = p_fit[2]
-sk_LL(pars_fit, g)

}
\seealso{
sk sk_GLS sk_var sk_pars_update

Other likelihood functions: 
\code{\link{sk_LL}()}

Other variance-related functions: 
\code{\link{sk_GLS}()},
\code{\link{sk_LL}()},
\code{\link{sk_cmean}()},
\code{\link{sk_sim}()},
\code{\link{sk_var}()}
}
\concept{likelihood functions}
\concept{variance-related functions}
