% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R, R/numeric_version.R
\name{extract-component}
\alias{extract-component}
\alias{extract_major}
\alias{extract_minor}
\alias{extract_patch}
\alias{extract_pre_release_ids}
\alias{extract_build_metadata}
\alias{extract_major.smvr}
\alias{extract_minor.smvr}
\alias{extract_patch.smvr}
\alias{extract_pre_release_ids.smvr}
\alias{extract_build_metadata.smvr}
\alias{extract_major.numeric_version}
\alias{extract_minor.numeric_version}
\alias{extract_patch.numeric_version}
\title{Extract each component of version numbers/labels}
\usage{
extract_major(x, ...)

extract_minor(x, ...)

extract_patch(x, ...)

extract_pre_release_ids(x, ...)

extract_build_metadata(x, ...)

\method{extract_major}{smvr}(x, ...)

\method{extract_minor}{smvr}(x, ...)

\method{extract_patch}{smvr}(x, ...)

\method{extract_pre_release_ids}{smvr}(x, ...)

\method{extract_build_metadata}{smvr}(x, ...)

\method{extract_major}{numeric_version}(x, ...)

\method{extract_minor}{numeric_version}(x, ...)

\method{extract_patch}{numeric_version}(x, ...)
}
\arguments{
\item{x}{A version object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
The extracted component of the version object.
\itemize{
\item \code{\link[=extract_major]{extract_major()}}, \code{\link[=extract_minor]{extract_minor()}}, and
\code{\link[=extract_patch]{extract_patch()}} return integer.
\item \code{\link[=extract_pre_release_ids]{extract_pre_release_ids()}} returns \link{pre_release_ids}.
\item \code{\link[=extract_build_metadata]{extract_build_metadata()}} returns character.
}
}
\description{
These functions extract the individual components of
version numbers or labels, such as major, minor,
patch numbers, or, pre-release identifiers and build metadata.
}
\examples{
sem_ver <- parse_semver(c("1.2.3-alpha+001", "2.0.0", NA))

extract_major(sem_ver)
extract_minor(sem_ver)
extract_patch(sem_ver)
extract_pre_release_ids(sem_ver)
extract_build_metadata(sem_ver)

# Extracting version also works for numeric_version
num_ver <- numeric_version(c("1", "3.1.4.1.5", NA), strict = FALSE)

extract_major(num_ver)
extract_minor(num_ver)
extract_patch(num_ver)
}
\seealso{
\itemize{
\item \code{\link[=smvr]{smvr()}} to create a \link{smvr} object from components.
\item \link{check-component} functions for checking if
\link{smvr} object has a specific component.
}
}
