% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_corr_avgErr.R
\name{sm_corr_avgErr}
\alias{sm_corr_avgErr}
\title{Superimposition of the average point with horizontal and vertical error bars
in the correlation plot}
\usage{
sm_corr_avgErr(
  data,
  x,
  y,
  point.params = list(size = 2.5),
  errh.params = list(height = 0),
  errv.params = list(width = 0),
  errorbar_type = "se",
  ...
)
}
\arguments{
\item{data}{Data frame variable that is used for plotting.}

\item{x}{Column of the data frame that represents the x-axis.}

\item{y}{Column of the data frame that represents the y-axis.}

\item{point.params}{List of parameters for the mean point, such as color, alpha, fill etc}

\item{errh.params}{List of parameters for the horizontal error bar, such as color, alpha, fill etc}

\item{errv.params}{List of parameters for the vertical points, such as color, alpha, fill etc}

\item{errorbar_type}{This argument determines the error bar type.
If it is set to 'se' , standard error bar will be shown.
If it is set to 'sd', the error bar will display standard deviation.
If it is set to 'ci' (default), the error bar will display 95\% confidence interval.}

\item{...}{A generic aesthetic parameter across points and error bars. This is optional.}
}
\value{
A point with error bars representing the average will be returned.
}
\description{
Superimposition of the average point with horizontal and vertical error bars
in the correlation plot
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, size = 3) +
  sm_corr_avgErr(mtcars, drat, mpg,
    errorbar_type = "se",
    color = sm_color("red")
  )
}
