% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_auc.R
\name{sm_auc}
\alias{sm_auc}
\title{Calculation of the Area under a Curve (Trapezoidal numerical integration)}
\usage{
sm_auc(x, y)
}
\arguments{
\item{x}{This is the scalar spacing of the coordinate.
When the argument for 'x' is not provided, it will calculates the
approximate integral value for ‘Y’ with unit spacing based on the length of ‘y’.}

\item{y}{Numerical data. The length of x and y must be equal.}
}
\value{
A vector that is the value from the trapezoidal integration is returned.
}
\description{
This is equivalent to Matlab's trapz function.
}
\examples{
library(smplot2)
X <- c(1, 2, 3, 4, 5)
Y1 <- c(2, 3, 4, 2, 3)
Y2 <- c(3, 3, 3, 3, 3)

sm_auc(X, Y2)
sm_auc(X, Y1)
}
