% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_add_legend.R
\name{sm_add_legend}
\alias{sm_add_legend}
\title{Adding a common legend on a combined figure}
\usage{
sm_add_legend(
  combined_plot,
  x,
  y,
  sampleplot,
  legend,
  direction = "vertical",
  border = TRUE,
  legend_spacing = 0.5,
  border_color = "black",
  font_size = 12
)
}
\arguments{
\item{combined_plot}{Combined figure, an output from sm_put_together().}

\item{x}{Location of the legend along the x-axis of the combined figure. The middle origin is at 0.5.}

\item{y}{Location of the legend along the y-axis of the combined figure. The middle origin is at 0.5.}

\item{sampleplot}{A variable containing one sample ggplot2 from which the legend can be derived.}

\item{legend}{Pre-specified layer of legend created with sm_common_legend().}

\item{direction}{Direction of the legend: 'horizontal' or 'vertical'.}

\item{border}{If set TRUE, border around the legend will be created.
If set FALSE, the border will be removed.}

\item{legend_spacing}{Spacing within the legend.}

\item{border_color}{Color of the legend border}

\item{font_size}{Text size of the legend}
}
\value{
It prints a legend on a a combined plot. It can be used to create
a common legend for subplots.
}
\description{
Adding a common legend on a combined figure
}
\examples{
library(ggplot2)
library(smplot2)

ggplot(data = mtcars, mapping = aes(
  x = drat, y = mpg,
  fill = as.factor(cyl)
)) +
  geom_point(
    shape = 21, color = "white",
    size = 3
  ) +
  sm_classic(legends = FALSE) -> p1

ggplot(data = mtcars, mapping = aes(
  x = drat, y = mpg,
  fill = as.factor(cyl)
)) +
  geom_point(
    shape = 21, color = "white",
    size = 3
  ) +
  sm_hvgrid(legends = FALSE) -> p2

combined_fig <- sm_put_together(list(p1, p2), ncol = 2, nrow = 1)
sm_add_legend(combined_fig, x = 0.1, y = 0.1, sampleplot = p1)

}
