% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_temporal_smos.R
\name{plot_temporal_smos}
\alias{plot_temporal_smos}
\title{Plot temporal series of BEC-SMOS soil moisture data}
\usage{
plot_temporal_smos(data, freq = NULL, orbit = NULL, dates = NULL, QA = NULL)
}
\arguments{
\item{data}{a data.matrix containing soil moisture data as produced by
\code{extract_smos()}.}

\item{freq}{an integer specifying temporal frequency of the data. Possible
values are: 1 - for daily data, 3 - for 3-day moving averages, and NULL -
for cases when data frequency is irrelevant. Default value is \code{NULL}.}

\item{orbit}{a character (or character string) specifying SMOS orbit
corresponding to the data. Possible values are: ‘a’, ‘asc’, and ‘ascending’ -
for an ascending pass, or ‘d’, ‘des’, or ‘descending’ - for a descending
pass, and NULL - for cases when orbit is irrelevant. Default value is
\code{NULL}.}

\item{dates}{a object of class \code{Date} or a character string formatted
as ‘yyyy-mm-dd’ (e.g. ‘2010-06-01’) which specifies the dates to plot the
data for. A multiple-element object of class Date or a vector should be
passed (e.g. as produced by \code{seq.Date}).}

\item{QA}{a numeric vector specifying the desired data quality to be plotted.
Possible values range from 0 (good quality data) to 15. To know the meanings
of QA flags, see Details.}
}
\value{
a line chart
}
\description{
This function plots temporal series of BEC-SMOS soil moisture data extracted
for specific geographical locations.
}
\details{
This function takes as input temporal series of BEC-SMOS soil moisture
estimates extracted for specific geographical locations and plots these data
as a line chart. Note that the data characterized by the same frequency and
SMOS orbit can be drawn at a time. If the dataset to plot contains a mixture
of temporal resolutions and/or SMOS passes, arguments \code{frequency} and
\code{orbit} must be specified. In addition, the dataset can be filtered by
desired data quality and specific dates to be plotted.

**** Quality assurance (QA) ****

QA flags are coded by four significant bits as described below:

\tabular{rcl}{
\tab -------------- \tab -------------------------------------------------------------------------------- \cr
\tab Bit position \tab Bit value \cr
\tab -------------- \tab -------------------------------------------------------------------------------- \cr
\tab [0] \tab 0 - Brightness temperature not affected by sea-land contamination \cr
\tab     \tab 1 - Brightness temperature corrected by sea-land contamination \cr
\tab ------------- \tab -------------------------------------------------------------------------------- \cr
\tab [1] \tab 0 - Radio Frequency Interference (RFI) not flagged in ESA L1C \cr
\tab     \tab brightness temperature \cr
\tab     \tab 1 - RFI flagged in ESA L1C brightness temperature \cr
\tab ------------- \tab -------------------------------------------------------------------------------- \cr
\tab [2] \tab 0 - L3 soil moisture with data obtained from L2 retrievals \cr
\tab     \tab 1 - L3 soil moisture with data obtained from a linear model \cr
\tab ------------- \tab -------------------------------------------------------------------------------- \cr
\tab [3] \tab 0 - L4 soil moisture values within the interval [0,1] m^3/m^3 \cr
\tab     \tab 1 - L4 soil moisture values outside the interval [0,1] m^3/m^3 \cr
\tab ------------- \tab -------------------------------------------------------------------------------- \cr
}

In case of the 3-day averaged data, each bit of the quality flag is activated
if at least one soil moisture estimate during the corresponding time interval
is affected.
}
\examples{
\dontrun{
# to plot extracted temporal series of BEC-SMOS soil moisture data produced by extract_smos()
# with the specified frequency, SMOS orbit and QA
smos_files <- list_smos()
lat <- c(40.42, 41.90, 48.86, 52.50, 59.91)
lon <- c(-3.70, 12.50, 2.35, 13.40, 10.75)
sm_estimates <- extract_smos(data = smos_files, lat = lat, lon = lon)
plot_temporal_smos(data = sm_estimates, freq = 3, orbit = "des", QA = 0)
}

}
\references{
Pablos M, Gonzalez-Haro C, Portal G, Piles M, Vall-llossera M,
Portabella M (2022). SMOS L4 Surface Soil Moisture downscaled maps at 1 km
EASE-2 (reprocessed mode) (V.6.0) [Dataset].
}
