% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_diff.R
\name{smooth_diff}
\alias{smooth_diff}
\title{Compute the Difference Between Initial and Smoothed Treatment}
\usage{
smooth_diff(treatment, smoothed_treatment)
}
\arguments{
\item{treatment}{a character vector containing the original treatment data..}

\item{smoothed_treatment}{a character vector containing the smoothed treatment return by \code{smooth_algorithm} function.}
}
\value{
A data.frame with three columns: diff_type , diff, change and treatment:

\describe{
\item{type}{A character vector representing indicating the type of difference computed.}
\item{days_changed}{The number of different items.}
\item{proportion_of_change}{The proportion of difference computed as number of diferent rows over number of rows.}
\item{treatment}{A character vector representing the type of treatment given to each patient.}
}
}
\description{
This function computes the differences between the initial treatment and the treatment when it's smoothed.
}
\examples{

library(smoothy)
library(dplyr)

data(drugstreatment)

my_data <- filter(drugstreatment, id == "01f13c15-d9f1-4106-a04f-976c457edd0a")

structured_df <- smooth_parse(
  id = my_data$id,
  start_date = my_data$start_date,
  end_date = my_data$end_date,
  drug = my_data$drug,
  study_from = "1970-01-01",
  study_to = "1975-01-01"
)

head(structured_df)

id = structured_df$id
treatment = structured_df$treatment
day = structured_df$day
N = structured_df$N
width = 61

smoothed <- smooth_algorithm(id = id, treatment = treatment, day = day, N = N, width = width)

head(smoothed)

smooth_diff(treatment = smoothed$treatment, smoothed_treatment = smoothed$smoothed_treatment)

}
