% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\title{Prepare data set for inverse probability weighting}
\usage{
prep_data(
  data,
  grace_period_length = 0,
  baseline_vars = NULL,
  lag_vars = NULL,
  n_lags = 1
)
}
\arguments{
\item{data}{Data frame containing the observed data}

\item{grace_period_length}{Numeric scalar indicating the length of the grace period, if applicable. The default is \code{0}, indicating no grace period.}

\item{baseline_vars}{Vector of character strings specifying the names of the baseline covariates that should be added to the observed data.}

\item{lag_vars}{Vector of character strings specifying the names of the covariates whose lags should be added as columns to the observed data. The number of lags is controlled by the \code{n_lags} argument.}

\item{n_lags}{Numeric scalar specifying the number of lags to use when computing the lagged values of \code{lag_vars}. Additional columns will be created for 1, ..., \code{n_lags} lags of the variables specified in \code{lag_vars}.}
}
\value{
A data table containing the observed data with the additional columns.
}
\description{
This function adds columns to the input data set to assist with inverse probability weighting. See details.
}
\details{
This function performs the following tasks:
\itemize{
\item Adds a column \code{C_artificial} which indicates when an individual should be artificially censored from the data when applying inverse probability weighting.
\item Adds a column \code{A_model_eligible} which indicates what records should be used for fitting the treatment adherence model.
\item If \code{baseline_vars} is supplied, it adds columns corresponding to the baseline value of these variables. These columns have the name \code{_baseline} appended to them.
\item If \code{lag_vars} is supplied, it adds columns corresponding to the lagged value of these variables. For each of these variables, additional columns will be created for 1, ..., \code{n_lags} lags of the variable.
}
}
\examples{
data_null_processed <- prep_data(data = data_null, grace_period_length = 2,
                                 baseline_vars = 'L')


}
