% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smle_ph.R
\name{smle_ph}
\alias{smle_ph}
\title{Fit the full likelihood proportional hazards model}
\usage{
smle_ph(y, d, x)
}
\arguments{
\item{y}{survival time (> 0).}

\item{d}{right-censoring indicator, \code{1}: observed; \code{0}: right-censored.}

\item{x}{p-dimensional covariates matrix.}
}
\value{
\code{smle_ph} returns a list containing the following components:
\itemize{
  \item \code{Coef}: regression estimator and its inferential results.
  \item \code{Cum.hazard}: baseline cumulative hazard function estimates.
}
}
\description{
Fit the proportional hazards model with maximum full likelihood estimation. Sieve estimation is used for estimating the baseline hazard function.
}
\details{
see Halabi et al., (2024+) for detailed method explanation.
}
\examples{
library(smlePH)
set.seed(111)
n = 200
beta = c(1, -1, 0.5, -0.5, 1)
p = length(beta)
beta = matrix(beta, ncol = 1)
R = matrix(c(rep(0, p^2)), ncol = p)
diag(R) = 1
mu = rep(0, p)
SD = rep(1, p)
S = R * (SD \%*\% t(SD))
x = MASS::mvrnorm(n, mu, S)
T = (-log(runif(n)) / (2 * exp(x \%*\% beta)))^(1/2)
C = runif(n, min = 0, max = 2.9)
y = apply(cbind(T,C), 1, min)
d = (T <= C)+0
ord = order(y)
y = y[ord]; x = x[ord,]; d = d[ord]
smle_ph(y = y, d = d, x = x)
}
\references{
Halabi et al., (2024+) Sieve maximum full likelihood estimation for the proportional hazards model
}
