% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphMat-main.R
\name{plot.morphMat}
\alias{plot.morphMat}
\title{Plot method for morphMat class (size at morphometric maturity)}
\usage{
\method{plot}{morphMat}(
  x,
  xlab = "X",
  ylab = "Proportion mature",
  col = c("blue", "red"),
  lwd = 2,
  lty = 2,
  vline_hist = "black",
  lwd_hist = 2,
  lty_hist = 2,
  onlyOgive = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class 'morphMat' with the mature parameters and a data.frame with the allometric variables ("X", "Y")
and classification of maturity. Also the fitted values for the logistic regression and confidence intervals (95\%).}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{col}{color for the logistic curve and for the L50\% size at morphometric maturity.}

\item{lwd}{line with for drawing fitted values and confidence intervals.}

\item{lty}{line type line type for drawing fitted values and confidence intervals}

\item{vline_hist}{color of the vertical lines in the histogram. The lines represent the
the median and the confidence intervals.}

\item{lwd_hist}{line with for the vertical line in the histogram.}

\item{lty_hist}{line type for the vertical line in the histogram.}

\item{onlyOgive}{plot only the ogive.}

\item{\dots}{Additional arguments to the plot method.}
}
\description{
Plot method for morphMat class (size at morphometric maturity)
}
\examples{
data(crabdata)

classify_data = classify_mature(crabdata, varNames = c("carapace_width", "chela_height"),
varSex = "sex_category", selectSex = NULL, method = "ld")

my_mature = morph_mature(classify_data, method = "fq", niter = 50)

plot(my_mature, xlab = "Carapace width (mm.)", ylab = "Proportion mature", col = c("blue", "red"))
}
