% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_attr}
\alias{aws_file_attr}
\title{File attributes}
\usage{
aws_file_attr(remote_path)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}
}
\value{
a tibble with many columns, with number of rows matching length
of \code{remote_path}
}
\description{
File attributes
}
\note{
uses \code{\link[s3fs:info]{s3fs::s3_file_info()}} internally
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(glue)
bucket <- random_bucket()
if (!aws_bucket_exists(bucket)) {
  aws_bucket_create(bucket)
}

# upload some files
tfiles <- replicate(n = 3, tempfile())
paths <- s3_path(bucket, glue("{basename(tfiles)}.txt"))
for (file in tfiles) cat("Hello saturn!!!!!!\n", file = file)
for (file in tfiles) print(readLines(file))
aws_file_upload(path = tfiles, remote_path = paths)

# files one by one
aws_file_attr(paths[1])
aws_file_attr(paths[2])
aws_file_attr(paths[3])
# or all together
aws_file_attr(paths)

# Cleanup
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_copy}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
