options(simulator.verbose = FALSE)

context("utils")

test_that("memory_as_string works", {
  expect_identical(memory_as_string(10), "10 Bytes")
  expect_identical(memory_as_string(12.34), "12.34 Bytes")
  expect_identical(memory_as_string(123.45), "123.45 Bytes")
  expect_identical(memory_as_string(1234.56), "1.23 KB")
  expect_identical(memory_as_string(12345.6), "12.35 KB")
  expect_identical(memory_as_string(123456), "123.46 KB")
  expect_identical(memory_as_string(1234567), "1.23 MB")
  expect_identical(memory_as_string(12345678), "12.35 MB")
  expect_identical(memory_as_string(123456789), "123.46 MB")
  expect_identical(memory_as_string(1234567891), "1.23 GB")
  expect_identical(memory_as_string(12345678912), "12.35 GB")
  expect_identical(memory_as_string(123456789123), "123.46 GB")
  expect_identical(memory_as_string(1234567891234), "1.23 TB")
})

test_that("get_relative_path works", {
  temp <- tempdir()
  dir <- file.path(temp, "example")
  sub <- file.path(dir, "sub")
  sub2 <- file.path(dir, "sub2")
  if (!dir.exists(dir)) dir.create(dir)
  if (!dir.exists(sub)) dir.create(sub)
  if (!dir.exists(sub2)) dir.create(sub2)
  expect_identical(get_relative_path(temp, dir), "example")
  expect_identical(get_relative_path(temp, sub), "example/sub")
  expect_identical(get_relative_path(dir, temp), "..")
  expect_identical(get_relative_path(sub, temp), "../..")
  expect_identical(get_relative_path(sub, sub2), "../sub2")
  unlink(dir, recursive = TRUE)
  wd <- strsplit(getwd(), split = "/")[[1]]
  lwd <- length(wd)
  expect_identical(get_relative_path("../..", "."),
                   file.path(wd[lwd - 1], wd[lwd]))
  expect_identical(get_relative_path("../..", ".."), wd[lwd - 1])
  expect_identical(get_relative_path("..", "../.."), "..")
})
