% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-class.R
\name{load_simulation}
\alias{load_simulation}
\title{Load a simulation object}
\usage{
load_simulation(name, dir = ".")
}
\arguments{
\item{name}{a short name identifier.  Must be alphanumeric.}

\item{dir}{directory that contains "files" directory for this simulation}
}
\description{
Loads an object of class \code{\linkS4class{Simulation}}.  Note that \code{dir}
gives the directory where the Simulation object is stored.  Thus, if the
working directory is different from the working directory when the Simulation
object was created, then \code{dir} will be different from the one passed to
\code{\link{new_simulation}}.
}
\examples{
sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir())
rm(sim)
sim <- load_simulation("normal-example", dir = tempdir())
}
\seealso{
\code{\link{new_simulation}} \code{\link{save_simulation}}
}
