% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evals-class.R
\docType{class}
\name{Evals-class}
\alias{Evals-class}
\title{An S4 class representing the evaluation of a metric run by simulator.}
\description{
An object of class \code{Evals} consists of information to identify the
model, draws, method, and metric objects this output was derived from. It
also has a list called \code{evals}, which is where the output of the metric
is stored.  Currently, the labels of all these objects are also included so
that plot functions can use human-readable labels without requiring
re-loading these.
}
\section{Slots}{

\describe{
\item{\code{model_name}}{the name of the \code{\linkS4class{Model}} object this output is
derived from.}

\item{\code{model_label}}{the label of the \code{\linkS4class{Model}} object this output is
derived from.}

\item{\code{index}}{the index of the \code{\linkS4class{Draws}} object this output is
derived from.}

\item{\code{method_name}}{the name of the \code{\linkS4class{Method}} object this output is
derived from.}

\item{\code{method_label}}{the label of the \code{\linkS4class{Method}} object this output
is derived from.}

\item{\code{metric_name}}{the name of the \code{\linkS4class{Metric}} object this output is
derived from.}

\item{\code{metric_label}}{the label of the \code{\linkS4class{Metric}} object this output
is derived from.}

\item{\code{evals}}{a named list with each element labeled by a method_name
each evals[[m]] is itself a named list with each element labeled
as \code{ri.j} where \code{i} is the \code{index} and \code{j} ranges
from \code{1} to \code{nsim}.  Element \code{out$ri.j} is output of
metric \code{metric_name} on random draw \code{ri.j}.}
}}

\seealso{
\code{\link{evaluate}} \code{\link{as.data.frame.Evals}}
}
