% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_factor_score_coefficients}
\alias{get_factor_score_coefficients}
\title{Return factor score coefficients}
\usage{
get_factor_score_coefficients(m, latent = TRUE, errors = FALSE, ...)
}
\arguments{
\item{m}{Structural model represented by lavaan syntax or output of sim_standardized_matrices function.}

\item{latent}{Include latent variables.}

\item{errors}{Include observed error and latent disturbances variables.}

\item{...}{parameters passed to the `sim_standardized_matrices` function}
}
\value{
A matrix of factor score coefficients
}
\description{
Return factor score coefficients
}
\examples{
m <- "
A =~ 0.5 * A1 + 0.8 * A2 + 0.8 * A3
B =~ 0.5 * B1 + 0.8 * B2 + 0.8 * B3
B ~ 0.5 * A
"
get_factor_score_coefficients(m)
}
