% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.prop}
\alias{analyze.simstudy.prop}
\title{Analyze Simulated Proportion Tests}
\usage{
analyze.simstudy.prop(
  test.statistics.prop,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.prop}{A data frame or data.table containing the summary table of
estimated coefficients from repeated proportion tests. Expected structure is similar to the output
of \code{simitation::sim.prop.test()}.}

\item{alternative}{A character string specifying the alternative hypothesis. Must be one of
"two.sided", "less", or "greater". Default is "two.sided".}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence level. Default is 0.95.}

\item{the.quantiles}{A numeric vector of values between 0 and 1. The function will return the
specified quantiles for summary statistics.}
}
\value{
A list containing various summary statistics for the proportion test.
}
\description{
This function analyzes the results of simulated tests for proportions, providing
various summary statistics about the test statistics, estimates, and confidence intervals.
}
\examples{

simdat.prop <- sim.prop(n = 30, p = 0.45,
num.experiments = 2, experiment.name = "simulation_id",
value.name = "success", seed = 104)

test.statistics.prop <- sim.prop.test(simdat.prop =
simdat.prop, p = 0.5, alternative = "two.sided",
conf.level = 0.99, correct = TRUE,
experiment.name = "simulation_id", value.name = "success")


analysis.prop <- analyze.simstudy.prop(test.statistics.prop =
test.statistics.prop, alternative = "two.sided", conf.level = 0.99,
the.quantiles = c(0.005, 0.995))
}
