% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare.test.R
\name{chisquare.test}
\alias{chisquare.test}
\title{chisquare.test}
\usage{
chisquare.test(x, case, which = "RGd")
}
\arguments{
\item{x}{data set}

\item{case}{setup info}

\item{which}{type of binning (either RGd, Equal Size or Equal Prob)}
}
\value{
A numeric vector of length 1 with the value of the chi-square statistic.
}
\description{
This function does the chisquare test
}
\examples{
case <- list(B=1000, param = NULL, n = 1000, pnull = function(x, param) punif(x), 
        rnull = function(n, param) runif(n), qnull = function(x, param) qunif(x), 
        est.mle = function(x) NA, nbins = 10)
x <- runif(1000)
chisquare.test(x, case)               
}
