% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effDisc_dks.R
\name{effDisc_dks}
\alias{effDisc_dks}
\title{Discrete Effectiveness as Discrete Kernel-smoothed Distribution.}
\usage{
effDisc_dks(x, support, mult = 1)
}
\arguments{
\item{x}{a sample of effectiveness scores between 0 and 1.}

\item{support}{the support of the distribution.}

\item{mult}{a constant to multiply the initially selected bandwidth.}
}
\value{
an object of class \code{eff.disc.dks}, which inherits from
  \code{\link[=eff.disc-class]{eff.disc}}.
}
\description{
Fits a Beta-Binomial distribution, to the given sample of scores and support points.
}
\examples{
e <- effDisc_dks(web2010p20[,1], seq(0,1,.05))
c(e$mean, e$var)
plot(e, plot.data = TRUE)
e2 <- effDisc_dks(web2010p20[,1], seq(0,1,.05), mult = 2)
c(e2$mean, e2$var)
plot(e2, plot.data = TRUE)
}
\references{
M.C. Wang and J.V. Ryzing (1981). A Class of Smooth Estimators for Discrete
  Distributions. Biometrika, 68, 301-309.
}
\seealso{
\code{\link{deff}}, \code{\link{peff}}, \code{\link{qeff}} and \code{\link{reff}}.
}
