% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateParams.R
\name{prepareData}
\alias{prepareData}
\title{Preparation of a Data Set to Compute Log-likelihood}
\usage{
prepareData(data)
}
\arguments{
\item{data}{(\code{data.frame})\cr containing entry and exit times of an illness-death model.
See \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}} for details.}
}
\value{
This function returns a data set with one row per patient and transition, when the patient is at risk.
}
\description{
Preparation of a Data Set to Compute Log-likelihood
}
\details{
The output data set contains the following columns:
\itemize{
\item id (\code{integer}): patient id.
\item from (\code{integer}): start event state.
\item to (\code{integer}): end event state.
\item trans (\code{integer}): transition (1, 2 or 3) identifier
\itemize{
\item \code{1}: Transition from state 0 (stable) to 1 (progression).
\item \code{2}: Transition from state 0 (stable) to 2 (death).
\item \code{3}: Transition from state 1 (progression) to 2 (death).
}
\item entry (\code{numeric}): time at which the patient begins to be at risk for the transition.
\item exit (\code{numeric}): time at which the patient ends to be at risk for the transition.
\item status (\code{logical}): event indicator for the transition.
}
}
\examples{
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
simData <- getOneClinicalTrial(
  nPat = c(30), transitionByArm = list(transition),
  dropout = list(rate = 0.8, time = 12),
  accrual = list(param = "time", value = 1)
)
prepareData(simData)
}
