% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corPFSOS.R
\name{expvalOSInteg}
\alias{expvalOSInteg}
\title{Helper Function for Computing E(OS^2)}
\usage{
expvalOSInteg(x, transition)
}
\arguments{
\item{x}{(\code{numeric})\cr variable of integration.}

\item{transition}{(\code{TransitionParameters})\cr
see \code{\link[=exponential_transition]{exponential_transition()}}, \code{\link[=weibull_transition]{weibull_transition()}} or \code{\link[=piecewise_exponential]{piecewise_exponential()}} for details.}
}
\value{
Numeric results of the integrand used to calculate E(OS^2).
}
\description{
Helper Function for Computing E(OS^2)
}
\examples{
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
expvalOSInteg(0.4, transition)
}
