% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitionParameters.R
\name{exponential_transition}
\alias{exponential_transition}
\title{Transition Hazards for Exponential Event Times}
\usage{
exponential_transition(h01 = 1, h02 = 1, h12 = 1)
}
\arguments{
\item{h01}{(positive \code{number})\cr transition hazard for 0 to 1 transition.}

\item{h02}{(positive \code{number})\cr transition hazard for 0 to 2 transition.}

\item{h12}{(positive \code{number})\cr transition hazard for 1 to 2 transition.}
}
\value{
List with elements \code{hazards}, \code{intervals}, \code{weibull_rates} and \code{family}
(exponential).
}
\description{
This creates a list with class \code{TransitionParameters} containing
hazards, time intervals and Weibull rates for exponential event times
in an illness-death model.
}
\examples{
exponential_transition(1, 1.6, 0.3)
}
