% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vexp}
\alias{vexp}
\title{Variate Generation for Exponential Distribution}
\usage{
vexp(n, rate = 1, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{rate}{Rate of distribution (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qexp]{stats::qexp}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qexp]{stats::qexp}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of exponential random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Exponential Distribution
}
\details{
Generates random variates from the exponential distribution.

Exponential variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qexp]{stats::qexp}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vexp} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ The exponential distribution with rate \eqn{\lambda} has density

     \deqn{f(x) = \lambda e^{-\lambda x}}{%
               f(x) = \lambda e^(-\lambda x)}

 for \eqn{x \geq 0}.
}\if{html}{\out{</div>}}
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qexp
 vexp(3, rate = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qexp
 vexp(3, 2, stream = 1)
 vexp(3, 2, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qexp
 vexp(1, 2, stream = 1)
 vexp(1, 2, stream = 2)
 vexp(1, 2, stream = 1)
 vexp(1, 2, stream = 2)
 vexp(1, 2, stream = 1)
 vexp(1, 2, stream = 2)

 set.seed(8675309)
 variates <- vexp(100, 2, stream = 1)
 set.seed(8675309)
 variates <- vexp(100, 2, stream = 1, antithetic = TRUE)

 set.seed(8675309)
 # NOTE: Default functions for M/M/1 ssq(), ignoring fixed n
 interarrivals <- vexp(1000, rate = 1,    stream = 1)
 services      <- vexp(1000, rate = 10/9, stream = 2)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rexp]{stats::rexp}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
