% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_extraterrestrialRadiation_for_shorter}
\alias{cal_extraterrestrialRadiation_for_shorter}
\title{Calculating extraterrestrial radiation for hourly or shorter periods}
\usage{
cal_extraterrestrialRadiation_for_shorter(lat, J, t, lz, lm, t1)
}
\arguments{
\item{lat}{latitude (radian), positive for the northern hemisphere and negative
for the southern hemisphere.}

\item{J}{is the number of the day in the year between 1 (1 January) and 365
or 366 (31 December).}

\item{t}{standard clock time at the midpoint of the period (hour). For example
for a period between 14.00 and 15.00 hours, t = 14.5.}

\item{lz}{longitude of the centre of the local time zone (degrees west of Greenwich).
For example, Lz = 75, 90, 105 and 120° for the Eastern, Central, Rocky Mountain
and Pacific time zones (United States) and Lz = 0° for Greenwich, 330°
for Cairo (Egypt),and 255° for Bangkok (Thailand), radian.}

\item{lm}{longitude of the measurement site (degrees west of Greenwich) radian.}

\item{t1}{length of the calculation period (hour)}
}
\value{
A vector for extraterrestrial Radiation (MJ m-2 hour-1)
}
\description{
Calculating extraterrestrial radiation for hourly or shorter periods
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
