% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformationFunctions.R
\name{transformers}
\alias{transformers}
\alias{trans_ratio}
\alias{trans_root}
\alias{trans_log}
\title{Data Transformation Functions}
\usage{
trans_ratio(x, method = c("sd", "mad"))

trans_root(x, fracRoot = 0.5)

trans_log(x, base = 10, shift = 1)
}
\arguments{
\item{x}{A numeric vector or column of a dataframe to be transformed.}

\item{method}{Character string specifying the method: "sd" (standard
deviation) or "mad" (median absolute deviation).}

\item{fracRoot}{The fractional power to which each element in \code{x} should be
raised. Defaults to 0.5 (square root).}

\item{base}{The base of the logarithm. Defaults to 10.}

\item{shift}{A numeric value added to \code{x} before applying the logarithm to
avoid log(0). Defaults to 1.}
}
\value{
A numeric vector where values are divided by the chosen method's
statistic.

A numeric vector of transformed values.

A numeric vector of transformed values.
}
\description{
This script provides transformation functions for data scaling
and normalization.
}
\examples{
trans_ratio(c(1, 2, 3, 4, 5), method = "sd")
trans_root(c(1, 4, 9, 16), fracRoot = 0.5)
trans_log(c(1, 10, 100, 1000), base = 10, shift = 1)
}
