% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateGroupData.R
\name{simulate_group_data}
\alias{simulate_group_data}
\title{Simulate Group Data}
\usage{
simulate_group_data(param_list, data_gen_fn, group_col_name)
}
\arguments{
\item{param_list}{A list of named sublists, where each sublist contains the
parameters for a group (mean, shape, rate, etc.). The list must be named with
group names that match the groupings stated in \code{group_col_name}.}

\item{data_gen_fn}{A function for data generation. Currently we can choose
either \code{generate_mvGamma_data} or \code{MASS::mvrnorm}.}

\item{group_col_name}{The name of the grouping/label column to be created in
the final data frame.}
}
\value{
A data frame with the simulated data for all groups, including the grouping column.
}
\description{
This function generates data for each group by invoking the
specified data generation function once per group. It binds the generated
data together into a single data frame.
}
\examples{
# Example using MASS::mvrnorm for normal distribution
param_list <- list(
  Group1 = list(mean_vec = c(1, 2), sampCorr_mat = matrix(c(1, 0.5, 0.5, 1), 2, 2), sampSize = 100),
  Group2 = list(mean_vec = c(2, 3), sampCorr_mat = matrix(c(1, 0.3, 0.3, 1), 2, 2), sampSize = 150)
)
simulate_group_data(param_list, MASS::mvrnorm, "Group")

# Example using generate_mvGamma_data for Gamma distribution
param_list <- list(
  Group1 = list(sampCorr_mat = matrix(c(1, 0.5, 0.5, 1), 2, 2),
                shape_num = c(2, 2), rate_num = c(1, 1), sampSize = 100),
  Group2 = list(sampCorr_mat = matrix(c(1, 0.3, 0.3, 1), 2, 2),
                shape_num = c(2, 2), rate_num = c(1, 1), sampSize = 150)
)
simulate_group_data(param_list, generate_mvGamma_data, "Group")

}
