% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc_styles.R
\name{get_layer_categories}
\alias{get_layer_categories}
\title{Get Layer Categories Based on Raster Values}
\usage{
get_layer_categories(from, r_clc = NULL)
}
\arguments{
\item{from}{A data origin. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{r_clc}{A `terra` raster object containing the raster values to filter the categories. If NULL,
returns all categories.}
}
\value{
A data frame containing the filtered categories with the following columns:
  - `id`: The category ID (integer).
  - `description`: The description of the category (character).
  - `color`: The color associated with the category in hexadecimal format (character).
}
\description{
Extracts the categories (IDs, descriptions, and colors) from the first style
definition stored in a GeoPackage or PostGIS database. The extracted categories
are filtered to include only those present in the raster values.
}
\details{
The function retrieves the style definitions from the `layer_styles` table in
the provided GeoPackage or PostGIS database. It filters the categories to include
only those whose IDs match the unique values present in the raster.

It is useful for associating raster values with their corresponding descriptions
and colors, typically for visualization or analysis tasks.
}
\examples{
gpkg_path <- system.file("extdata", "clc.gpkg", package = "clc")

categories <- get_layer_categories(from = gpkg_path)
}
\seealso{
Other style functions: 
\code{\link{copy_styles}()}
}
\concept{style functions}
