% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_features.R
\name{show_cn_features}
\alias{show_cn_features}
\title{Show Copy Number Feature Distributions}
\usage{
show_cn_features(
  features,
  method = "Wang",
  rm_outlier = FALSE,
  ylab = NULL,
  log_y = FALSE,
  return_plotlist = FALSE,
  base_size = 12,
  nrow = 2,
  align = "hv",
  ...
)
}
\arguments{
\item{features}{a feature \code{list} generate from \link{sig_tally} function.}

\item{method}{method for feature classification, can be one of
"Wang" ("W"), "S" (for method described in Steele et al. 2019),
"X" (for method described in Tao et al. 2023).}

\item{rm_outlier}{default is \code{FALSE}, if \code{TRUE}, remove outliers. Only
works when method is "Wang" ("W").}

\item{ylab}{lab of y axis.}

\item{log_y}{logical, if \code{TRUE}, show \code{log10} based y axis, only
works for input from "Wang" ("W") method.}

\item{return_plotlist}{if \code{TRUE}, return a list of ggplot objects but a combined plot.}

\item{base_size}{overall font size.}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{align}{(optional) Specifies whether graphs in the grid should be horizontally ("h") or
vertically ("v") aligned. Options are "none" (default), "hv" (align in both directions), "h", and "v".}

\item{...}{other options pass to \code{\link[cowplot]{plot_grid}} function of \code{cowplot} package.}
}
\value{
a \code{ggplot} object
}
\description{
Show Copy Number Feature Distributions
}
