% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortableTabsetPanel.R
\name{sortableTabsetPanel}
\alias{sortableTabsetPanel}
\title{Create a tabset panel with sortable tabs}
\usage{
sortableTabsetPanel(
  ...,
  id = NULL,
  selected = NULL,
  type = c("tabs", "pills", "hidden"),
  header = NULL,
  footer = NULL
)
}
\arguments{
\item{...}{\code{\link[shiny:tabPanel]{tabPanel()}} elements to include in the tabset}

\item{id}{If provided, you can use \verb{input$}\emph{\code{id}} in your
server logic to determine which of the current tabs is active. The value
will correspond to the \code{value} argument that is passed to
\code{\link[shiny:tabPanel]{tabPanel()}}.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{type}{\describe{
\item{\code{"tabs"}}{Standard tab look}
\item{\code{"pills"}}{Selected tabs use the background fill color}
\item{\code{"hidden"}}{Hides the selectable tabs. Use \code{type = "hidden"} in
conjunction with \code{\link[shiny:tabPanel]{tabPanelBody()}} and \code{\link[shiny:updateTabsetPanel]{updateTabsetPanel()}} to control the
active tab via other input controls. (See example below)}
}}

\item{header}{Tag or list of tags to display as a common header above all
tabPanels.}

\item{footer}{Tag or list of tags to display as a common footer below all
tabPanels}
}
\value{
A tabset that can be passed to \link[shiny:sidebarLayout]{shiny::mainPanel}
}
\description{
Create a tabset that contains \link[shiny:tabPanel]{shiny::tabPanel} elements. The tabs are
sortable by drag and drop. In addition to the activated tab title stored in
\verb{input$<id>}, the server will also receive the order of tabs in
\verb{input$<id>_order}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      sortableTabsetPanel(
        id = "tabs",
        tabPanel(title = "A", "AAA"),
        tabPanel(title = "B", "BBB"),
        tabPanel(title = "C", "CCC")
      ),
      verbatimTextOutput("order")
    ),
    server = function(input, output) {
      output$order <- renderPrint({input$tabs_order})
    }
  )
}

}
\seealso{
\link[shiny:tabsetPanel]{shiny::tabsetPanel}, \link{sortableRadioButtons},
\link{sortableCheckboxGroupInput}, \link{sortableTableOutput}
}
