% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat_restore.R
\name{chat_restore}
\alias{chat_restore}
\title{Add Shiny bookmarking for shinychat}
\usage{
chat_restore(
  id,
  client,
  ...,
  bookmark_on_input = TRUE,
  bookmark_on_response = TRUE,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{The ID of the chat element}

\item{client}{The \pkg{ellmer} LLM chat client.}

\item{...}{Used for future parameter expansion.}

\item{bookmark_on_input}{A logical value determines if the bookmark should be updated when the user submits a message. Default is \code{TRUE}.}

\item{bookmark_on_response}{A logical value determines if the bookmark should be updated when the response stream completes. Default is \code{TRUE}.}

\item{session}{The Shiny session object}
}
\value{
Returns nothing (\code{invisible(NULL)}).
}
\description{
Adds Shiny bookmarking hooks to save and restore the \pkg{ellmer} chat
\code{client}. Also restores chat messages from the history in the \code{client}.

If either \code{bookmark_on_input} or \code{bookmark_on_response} is \code{TRUE}, the Shiny
App's bookmark will be automatically updated without showing a modal to the
user.

Note: Only the \code{client}'s chat state is saved/restored in the bookmark. If
the \code{client}'s state doesn't properly capture the chat's UI (i.e., a
transformation is applied in-between receiving and displaying the message),
then you may need to implement your own \code{session$onRestore()} (and possibly
\code{session$onBookmark}) handler to restore any additional state.

To avoid restoring chat history from the \code{client}, you can ensure that the
history is empty by calling \code{client$set_turns(list())} before passing the
client to \code{chat_restore()}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(bslib)
library(shinychat)

ui <- function(request) {
  page_fillable(
    chat_ui("chat", fill = TRUE)
  )
}

server <- function(input, output, session) {
  chat_client <- ellmer::chat_ollama(
    system_prompt = "Important: Always respond in a limerick",
    model = "qwen2.5-coder:1.5b",
    echo = TRUE
  )
  # Update bookmark to chat on user submission and completed response
  chat_restore("chat", chat_client)

  observeEvent(input$chat_user_input, {
    stream <- chat_client$stream_async(input$chat_user_input)
    chat_append("chat", stream)
  })
}

# Enable bookmarking!
shinyApp(ui, server, enableBookmarking = "server")
\dontshow{\}) # examplesIf}
}
